// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     extensions/common/api/mime_handler.mojom
//

package org.chromium.mojom.extensions.mime_handler;

public final class StreamInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(48, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public String mimeType;
    public String originalUrl;
    public String streamUrl;
    public int tabId;
    public java.util.Map<String, String> responseHeaders;
    public boolean embedded;

    private StreamInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public StreamInfo() {
        this(0);
    }

    public static StreamInfo deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static StreamInfo decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        StreamInfo result = new StreamInfo(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.mimeType = decoder0.readString(8, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.originalUrl = decoder0.readString(16, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.streamUrl = decoder0.readString(24, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.tabId = decoder0.readInt(32);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.embedded = decoder0.readBoolean(36, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
            {
                decoder1.readDataHeaderForMap();
                String[] keys0;
                String[] values0;
                {
                    org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE, false);
                    {
                        org.chromium.mojo.bindings.DataHeader si2 = decoder2.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        keys0 = new String[si2.elementsOrVersion];
                        for (int i2 = 0; i2 < si2.elementsOrVersion; ++i2) {
                            keys0[i2] = decoder2.readString(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                        }
                    }
                }
                {
                    org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE, false);
                    {
                        org.chromium.mojo.bindings.DataHeader si2 = decoder2.readDataHeaderForPointerArray(keys0.length);
                        values0 = new String[si2.elementsOrVersion];
                        for (int i2 = 0; i2 < si2.elementsOrVersion; ++i2) {
                            values0[i2] = decoder2.readString(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                        }
                    }
                }
                result.responseHeaders = new java.util.HashMap<String, String>();
                for (int index0 = 0; index0 < keys0.length; ++index0) {
                    result.responseHeaders.put(keys0[index0],  values0[index0]);
                }
            }
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(mimeType, 8, false);
        encoder0.encode(originalUrl, 16, false);
        encoder0.encode(streamUrl, 24, false);
        encoder0.encode(tabId, 32);
        encoder0.encode(embedded, 36, 0);
        if (responseHeaders == null) {
            encoder0.encodeNullPointer(40, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encoderForMap(40);
            int size0 = responseHeaders.size();
            String[] keys0 = new String[size0];
            String[] values0 = new String[size0];
            int index0 = 0;
            for (java.util.Map.Entry<String, String> entry0 : responseHeaders.entrySet()) {
                keys0[index0] = entry0.getKey();
                values0[index0] = entry0.getValue();
                ++index0;
            }
            {
                org.chromium.mojo.bindings.Encoder encoder2 = encoder1.encodePointerArray(keys0.length, org.chromium.mojo.bindings.DataHeader.HEADER_SIZE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i1 = 0; i1 < keys0.length; ++i1) {
                    encoder2.encode(keys0[i1], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                }
            }
            {
                org.chromium.mojo.bindings.Encoder encoder2 = encoder1.encodePointerArray(values0.length, org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i1 = 0; i1 < values0.length; ++i1) {
                    encoder2.encode(values0[i1], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                }
            }
        }
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        StreamInfo other = (StreamInfo) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mimeType, other.mimeType))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.originalUrl, other.originalUrl))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.streamUrl, other.streamUrl))
            return false;
        if (this.tabId != other.tabId)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.responseHeaders, other.responseHeaders))
            return false;
        if (this.embedded != other.embedded)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mimeType);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(originalUrl);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(streamUrl);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(tabId);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(responseHeaders);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(embedded);
        return result;
    }
}

